/*
 *  ESFlashView_FLVSupport.h
 *  Flash'In'App
 *
 *  Copyright 2008 Eltima Software. All rights reserved.
 *
 *	Flash'In'App is free for non-commercial use.
 *	If you plan to integrate it in commercial software, please, make sure you are acquainted with the license terms and obtain the Commercial License.
 *	Please, contact Eltima at sales@eltima.com or visit http://mac.eltima.com
 */

#import <Cocoa/Cocoa.h>
#import <FlashInApp/ESFlashView.h>

@interface ESFlashView(FLVSupport)

/*
 * loads FLV file from specified path
 */
- (BOOL) loadFlvAtPath:(NSString *)flvName;

- (BOOL) setFlvName:(NSString*)name;

/*
 * Plays/Stops playing FLV file
 */
- (BOOL) playFlv;
- (BOOL) stopPlayFlv;

/*
 * Rewinds FLV file.
 */
- (BOOL) rewindFlv;

/*
 * Gets total FLV playing time.
 */
- (double) totalTime;

/*
 * Gets current FLV playback time
 */
- (double) currentTime;

/*
 * Go to specified playback time of FLV file
 */
- (BOOL) gotoTime:(double)time;

/*
 * Move to the previous/next second.
 */
- (BOOL) backFlv;
- (BOOL) forwardFlv;

/*
 * Sets repeat function state.
 */
- (BOOL) setRepeatStyle:(BOOL)repeat;

/*
 * Gets FLV file width and height.
 */
- (BOOL) getFlvWidth:(float*)width height:(float*)height;

@end
